
#ifndef _BC5602_REG_H_
#define _BC5602_REG_H_
								
/*--------------------------- BC5602 strobe command ------------------------*/
#define	WRITE_REGS_CMD					0x40  	/* Register write command */
#define	READ_REGS_CMD					0xC0  	/* Register read command */
#define	REGS_BANK_CMD      			0x20  	/* Set Register Bank command */
#define	WRITE_TRXADDR_CMD  			0x10  	/* Write Tx & Rx Addr0 command 3~5Bytes */
#define	READ_TRXADDR_CMD   			0x90  	/* Read Tx & Rx Addr0 command 3~5Bytes */
#define	WRITE_ACKPLD_CMD      		0x11  	/* Write TX Ack payload command 1~32Bytes */
#define	READ_PLD_CMD       			0xBF  	/* Read RX payload command 1~32Bytes */
#define	WRITE_RXADDR1_CMD  			0x12  	/* Write Rx Addr1 command 3~5Bytes */
#define	READ_RXADDR1_CMD   			0x92  	/* Read Rx Addr1 command 3~5Bytes */
#define	WRITE_NACKPLD_CMD      		0x13  	/* Write TX NAck payload command 1~32Bytes */
#define	WRITE_P0ACKPLD_CMD      	0x18  	/* Write Rx Pipe0 Ack payload command 1~32Bytes */
#define	WRITE_P1ACKPLD_CMD      	0x19  	/* Write Rx Pipe1 Ack payload command 1~32Bytes */
#define	WRITE_P2ACKPLD_CMD      	0x1A  	/* Write Rx Pipe2 Ack payload command 1~32Bytes */
#define	WRITE_P3ACKPLD_CMD      	0x1B  	/* Write Rx Pipe3 Ack payload command 1~32Bytes */
#define	WRITE_P4ACKPLD_CMD      	0x1C  	/* Write Rx Pipe4 Ack payload command 1~32Bytes */
#define	WRITE_P5ACKPLD_CMD      	0x1D  	/* Write Rx Pipe5 Ack payload command 1~32Bytes */
#define	SOFT_RESET_CMD      			0x08  	/* Software reset command */
#define	TX_FIFO_FLUSH_CMD     		0x09  	/* TX FIFO flush command */
#define	RX_FIFO_FLUSH_CMD     		0x89  	/* RX FIFO flush command */
#define	DEEP_SLEEP_CMD      			0x0A  	/* Enter Deep Sleep mode */
#define	LIGHT_SLEEP_CMD     			0x0C  	/* Enter Light Sleep mode */
#define	STANDBY_MODE_CMD    			0x0D  	/* Enter Standby mode */
#define	TX_MODE_CMD         			0x0E  	/* Enter TX mode */
#define	MIDDLE_SLEEP_CMD				0x0F     /* Enter Middle Sleep mode */
#define	RX_MODE_CMD         			0x8E  	/* Enter RX mode */
#define	REGSADDR_MASK       			0x3F

/*------------- BC5602 Common & Bank0 register memory map ------------------*/
#define	CONFIG_REGS 					0x00		/* Configuration Control Register */
#define	CLK_CTL1_REGS 					0x01		/* Reset/Clock Control Register */
#define	CLK_CTL2_REGS 					0x02		/* Reset/Clock Control Register */
#define	IRQ_EN_REGS						0x03		/* Interrupt enable register */
#define	IRQ_STS_REGS					0x04		/* interrupt status register */
#define	FIFO_STS_REGS					0x05		/* FIFO Status Control Register */
#define	GPIO12_CTL_REGS 				0x06		/* GPIO 1/2 control register */
#define	GPIO34_CTL_REGS				0x07		/* GPIO 3/4 control register */
#define	GPIO_PULL_UP_REGS				0x08		/* SPI/GPIO pull high control register */
#define	CRC_CTL_REGS					0x09
#define	WHITENING_REGS					0x0A
#define	WHT_PCF_REGS					0x0B
#define	RX_PLWID_REGS					0x0C
#define DLY_CTL_REGS				   0x0D
#define	MOD_CTL1_REGS					0x0E
#define	MOD_CTL2_REGS					0x0F
#define	RF_CH_REGS						0x10
#define	DMOD_CTL1_REGS					0x11
#define	DMOD_CTL2_REGS					0x12
#define	SETUP_RETR_REGS				0x13
#define	OBSERVE_TX_REGS				0x14
#define	CE_CTL_REGS						0x15
#define	CP21_REGS						0x16
#define	CP22_REGS						0x17
#define	CP31_REGS						0x18
#define	OPM_CTL_REGS					0x20
#define	CFO_CTL_REGS					0x21
#define	FNS_DN_REGS						0x22
#define	FNS_DKL_REGS					0x23
#define	FNS_DKM_REGS					0x24
#define	FNS_DKH_REGS					0x25
#define	OPM_STS_REGS					0x26
#define	RSSI_CTL_REGS					0x27
#define	RSSI_VALUE_REGS				0x28
#define	RSSI_VALUE_ID_REGS			0x29
#define	DYNPL_CTL_REGS					0x2A
#define	FEATURE_CTL_REGS				0x2B
#define	RX_DPWP0_REGS					0x2C
#define	RX_DPWP1_REGS					0x2D
#define	RX_DPWP2_REGS					0x2E
#define	RX_DPWP3_REGS					0x2F
#define	RX_DPWP4_REGS					0x30
#define	RX_DPWP5_REGS					0x31
#define	EN_AA_REGS						0x32
#define	RX_ADDRP2_REGS					0x33
#define	RX_ADDRP3_REGS					0x34
#define	RX_ADDRP4_REGS					0x35
#define	RX_ADDRP5_REGS					0x36
#define	RX_ADDR_EN_REGS				0x37
#define	XO_CAP_CTL_REGS				0x38
#define	XO_SEL_CTL_REGS				0x39
#define	TX_PWR_CTL_REGS				0x3A
#define	DMOD_CTL3_REGS					0x3B
/*------------------ BC5602 Bank1 register memory map ----------------------*/
#define AGC_CTL1_REGS					0x20
#define AGC_CTL2_REGS					0x21
#define AGC_CTL3_REGS					0x22
#define AGC_CTL4_REGS					0x23
#define FCF_CTL1_REGS 					0x24
#define FCF_CTL2_REGS 					0x25
#define FCF_CTL3_REGS 					0x26
#define FCF_CTL4_REGS 					0x27
/*------------------ BC5602 Bank2 register memory map ------------------------*/
#define GAIN_CTL_REGS 					0x21
#define RX2_CTL_REGS 					0x2F
#define TX_PWR_CTL2_REGS				0x34
#define TX_PWR_CTL3_REGS				0x35

#endif	/* _BC5602_REG_H_ */
